package org.simantics.db.server;

import java.io.File;
import java.nio.file.Path;

import org.simantics.db.Database;
import org.simantics.db.exception.SDBException;
import org.simantics.db.server.internal.DatabaseI;
import org.simantics.db.server.internal.DatabaseManager;

public class Auxiliary {
    public static void ignoreExit(File dbFolder)
    throws ProCoreException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        if (!db.ignoreExit())
            throw new ProCoreException("Ignoring exit status did not help.");
    }
    public static void ignoreProtocol(File dbFolder)
    throws ProCoreException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        if (!db.ignoreProtocol())
            throw new ProCoreException("Ignoring protocol version did not help.");
    }
    public static void copyDatabase(File dbFolder, File dbTo)
    throws ProCoreException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        db.copy(dbTo);
    }
    public static boolean purgeDatabaseDone(File dbFolder)
    throws ProCoreException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        return !db.canPurge();
    }
    public static void purgeDatabase(File dbFolder)
    throws SDBException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        db.purge();
    }
    public static void deleteDatabase(File dbFolder)
    throws ProCoreException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        db.deleteDatabaseFiles();
    }
    public static void deleteDatabaseFiles(File dbFolder)
    throws ProCoreException {
        DatabaseI.deleteDatabaseFiles(dbFolder.toPath());
    }
    public static boolean canReadJournal(File dbFolder)
    throws ProCoreException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        Database.Journal j = db.getJournal();
        return j.canRead();
    }
    public static Path replaceFromJournal(File dbFolder)
    throws SDBException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        db.replaceFromJournal();
        return dbFolder.toPath();
    }
    public static Path saveDatabase(File dbFolder)
    throws ProCoreException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        return db.saveDatabase();
    }
    public static Path saveDatabase(File dbFolder, Path parent)
    throws ProCoreException {
        DatabaseI db = DatabaseManager.getDatabase(dbFolder.toPath());
        return db.saveDatabase(parent);
    }
}
