/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procore.cluster;

import org.simantics.db.impl.TableSizeListener;

final class ObjectHash extends TableIntHash {
    ObjectHash(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(sizeListener, header, headerBase);
    }
    ObjectHash(TableSizeListener sizeListener, int[] header, int headerBase, int[] ints) {
        super(sizeListener, header, headerBase, ints);
    }
    final int getObjectIndex(int key1, int key2) {
        int objectIndex = getValue(key1, key2);
        assert(objectIndex >= 0);
        return objectIndex;
    }
    final boolean removeObjectIndex(int key1, int key2) {
        return removeValue(key1, key2);
    }
    final void setObjectIndex(int key1, int key2, int objectIndex) {
        assert(objectIndex >= 0);
        setValue(key1, key2, objectIndex);
    }
}
