package fi.vtt.simantics.procore.internal;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.support.ResourceSupport;

public class ResourceSupportImpl implements ResourceSupport {

	final private SessionImplSocket session;
	
	ResourceSupportImpl(SessionImplSocket session) {
		this.session = session;
	}
	
	@Override
	public long getRandomAccessId(int id) {
		try {
			return session.resourceSerializer.createRandomAccessId(id);
		} catch (DatabaseException e) {
			e.printStackTrace();
		}
		return 0;
	}

	@Override
	public long getRandomAccessIdChecked(int id) throws DatabaseException {
		return session.resourceSerializer.createRandomAccessId(id);
	}

}
