package fi.vtt.simantics.procore.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.simantics.db.Operation;
import org.simantics.db.service.ExternalOperation;

public class OperationImpl implements Operation {
    private final long id;
    private final long csid;
    private Operation combined;
    private final List<ExternalOperation> externals;
    OperationImpl(long id, long csid) {
        this(id, csid, null);
    }
    OperationImpl(long id, long csid, List<ExternalOperation> externals) {
        this.id = id;
        this.csid = csid;
        this.combined = null;
        this.externals = externals.isEmpty() ? null : externals;
    }
    @Override
    public String toString() {
        return "Operation id=" + id + " cs=" + csid + ".";
    }
    @Override
    public long getId() {
        return id;
    }

    @Override
    public long getCSId() {
        return csid;
    }

    @Override
    public void combine(Operation operation) {
    	combined = operation;
    }

    @Override
    public List<Operation> getOperations() {
    	
    	if(combined == null) return Collections.<Operation>singletonList(this);

    	ArrayList<Operation> result = new ArrayList<Operation>();
    	OperationImpl current = this;
    	while(current != null) {
    		result.add(current);
    		current = (OperationImpl)(current.combined);
    	}
    	
    	Collections.reverse(result);
    	
    	return result;
    	
    }
    
    @Override
    public Collection<ExternalOperation> getExternalOperations() {
    	if(externals == null)
    		return Collections.emptyList();
    	else
    		return externals;
    }
    
}
