package fi.vtt.simantics.procore.internal;

import org.simantics.db.event.ChangeListener;
import org.simantics.db.service.GraphChangeListenerSupport;

public class GraphChangeListenerSupportImpl implements GraphChangeListenerSupport {
	
	final private SessionImplSocket session;
	
	GraphChangeListenerSupportImpl(SessionImplSocket session) {
		this.session = session;
	}
    
    @Override
    public void addListener(ChangeListener l) {
        session.changeListeners2.add(l);
    }

    @Override
    public void removeListener(ChangeListener l) {
    	session.changeListeners2.remove(l);
    }

    @Override
    public void addMetadataListener(ChangeListener l) {
    	session.metadataListeners.add(l);
    }

    @Override
    public void removeMetadataListener(ChangeListener l) {
    	session.metadataListeners.remove(l);
    }
    
}
