/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.management.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.db.SessionManager;
import org.simantics.utils.FileUtils;

import fi.vtt.simantics.procore.SessionManagerSource;

/**
 * Complete hack for the time being. Simply provides the SessionManager behind
 * procore's SessionManagerSource with proper initialization.
 */
public final class SessionManagerProvider {

    // TODO: move this into BundleContext as a service ?
    private static SessionManagerProvider provider;

    private SessionManager sessionManager;

    public static SessionManagerProvider getInstance() {
        if (provider == null)
            provider = new SessionManagerProvider();
        return provider;
    }

    public SessionManager getSessionManager() throws IOException {
        if (sessionManager == null) {
            sessionManager = SessionManagerSource.getSessionManager(loadProperties());
        }
        return sessionManager;
    }

    private Properties loadProperties() {
        Bundle procore = Platform.getBundle("org.simantics.db.procore");
        URL url = procore.getResource("log4j.properties");
        if (url != null) {
            InputStream in = null;
            try {
                in = url.openStream();
                Properties props = new Properties();
                props.load(in);
                return props;
            } catch (Exception e) {
            } finally {
                FileUtils.uncheckedClose(in);
            }
        }
        return null;
    }

}
