/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.management.discovery;

import org.simantics.db.service.ServerInformation;


/**
 * @author Tuukka Lehtonen
 */
public class ServerInfo {

    public static final ServerInfo[] NONE = {};

    private final String             name;

//    private final ServerAddress  address;
    
    private final ServerInformation  info;
    
    private final String aux_info;

    /**
     * @param name
     * @param address
     * @throws IllegalArgumentException if the address is not in host:port
     *         format
     */
//    public ServerInfo(String name, String address) throws IllegalArgumentException {
//        this(name, address, null, null);
//    }
    
//    public ServerInfo(String name, String address, String aux_info) throws IllegalArgumentException {
//        this(name, address, null, aux_info);
//    }
//
//    public ServerInfo(String name) {
//        this(name, null);
//    }
//    
//    public ServerInfo(String name, String aux_info) {
//        this(name, aux_info, null);
//    }
//
//    public ServerInfo(String name, String address, ServerInformation info) throws IllegalArgumentException {
//        this(name, address, info, null);
//    }
//
    public ServerInfo(String name, ServerInformation info, String aux_info) throws IllegalArgumentException {
        this.name = name;
//        this.address = address == null ? null : new ServerAddress(address);
        this.info = info;
        this.aux_info = aux_info;
    }
//
//    public ServerInfo(String name, ServerInformation info) {
//        this(name, address, info, null);
//    }
//    
//    public ServerInfo(String name, ServerInformation info, String aux_info) {
//        this.name = name;
////        this.address = address;
//        this.info = info;
//        this.aux_info = aux_info;
//    }

    public String getName() {
        return name;
    }

//    public ServerAddress getAddress() {
//        return address;
//    }

    public ServerInformation getInfo() {
        return info;
    }
    
    public String getAuxInfo() {
    	return aux_info;
    }

    @Override
    public String toString() {
    	String str = name + " "; //+ address;
    	if(aux_info != null)
    		str += " "+aux_info;
    	return str;
    }

    @Override
    public int hashCode() {
        return ((name == null) ? 0 : name.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null || getClass() != obj.getClass())
            return false;
        final ServerInfo other = (ServerInfo) obj;
//        if (address == null) {
//            if (other.address != null)
//                return false;
//            // The name field is used for equals
//            // only when the address is null.
//            if (!name.equals(other.name))
//                return false;
//        } else if (!address.equals(other.address))
//            return false;
        return true;
    }

//    public ServerInfo withAddress(ServerAddress address) {
//        return new ServerInfo(name, address);
//    }

}
