package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class VariableWriteWithComment extends WriteRequest {

    private Variable variable;
    private Object   value;
    private Binding  binding;
    private String   comment;

    public VariableWriteWithComment(Variable variable, Object value, Binding binding, String comment) {
        this.variable = variable;
        this.value = value;
        this.binding = binding;
        this.comment = comment;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        variable.setValue(graph, value, binding);
        if (comment != null) {
            CommentMetadata m = graph.getMetadata(CommentMetadata.class);
            graph.addMetadata(m.add(comment));
        }
    }

}