package org.simantics.db.layer0.request.external;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.IPreferenceChangeListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.PreferenceChangeEvent;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;

/**
 * @author Antti Villberg
 * @since 1.22.0
 */
public class EclipsePreferencePrimitiveRead extends ParametrizedPrimitiveRead<Pair<String,String>,String> implements IPreferenceChangeListener {

    private Listener<String> listener;

    public EclipsePreferencePrimitiveRead(String plugin, String key) {
        super(Pair.make(plugin, key));
    }

    @Override
    public void register(ReadGraph graph, Listener<String> procedure) {
        IEclipsePreferences preferenceNode = resolvePreferenceNode();
        if (!procedure.isDisposed() && preferenceNode != null) {
            preferenceNode.addPreferenceChangeListener(this);
        }
        listener = procedure;
        String value = preferenceNode != null ? preferenceNode.get(parameter.second, null) : null;
        procedure.execute(value);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        if (parameter.second.equals(event.getKey())) {
            IEclipsePreferences preferenceNode = resolvePreferenceNode();
            String value = preferenceNode != null ? preferenceNode.get(parameter.second, null) : null;
            listener.execute(value);
        }
    }

    @Override
    public void unregistered() {
        IEclipsePreferences preferenceNode = resolvePreferenceNode();
        if (preferenceNode != null) {
            preferenceNode.removePreferenceChangeListener(this);
        }
        listener = null;
    }

    private IEclipsePreferences resolvePreferenceNode() {
        IEclipsePreferences preferenceNode = InstanceScope.INSTANCE.getNode( parameter.first );
        return preferenceNode;
    }

}
