/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.genericrelation.combinators;

import gnu.trove.list.array.TIntArrayList;

import java.util.ArrayList;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.AbstractRelation;
import org.simantics.utils.datastructures.Pair;


public class SelectByRelation extends AbstractRelation {
	
	GenericRelation base;
	int baseLength;
	String bindingPattern;
	int[] boundPositions;
	GenericRelation constraint;
	
	public SelectByRelation(GenericRelation base, String bindingPattern, GenericRelation constraint) {
		super();
		this.base = base;
		this.bindingPattern = bindingPattern;
		TIntArrayList boundPositionArray = new TIntArrayList();
		baseLength = bindingPattern.length();
		for(int i=0;i<baseLength;++i)
			if(bindingPattern.charAt(i) == 'b') 
				boundPositionArray.add(i);
		boundPositions = boundPositionArray.toArray();
		this.constraint = constraint;
	}
	
	private Object[] map(Object[] tuple) {
		Object[] result = new Object[boundPositions.length];
		for(int i=0;i<result.length;++i)
			result[i] = tuple[boundPositions[i]];
		return result;
	}
	
	@Override
	public boolean contains(ReadGraph g, Object[] tuple) throws DatabaseException {
		assert tuple.length == baseLength;
		return base.contains(g, tuple) && constraint.contains(g, map(tuple));
	}
	@Override
	public Pair<String, String>[] getFields() {
		return base.getFields();
	}
	@Override
	public boolean isRealizable() {
		return base.isRealizable();
	}
	@Override
	public GenericRelation select(String bindingPattern, Object[] constants) {
		return new SelectByRelation(base.select(bindingPattern, constants), bindingPattern, constraint);
	}
	@Override
	public List<Object[]> realize(ReadGraph g) throws DatabaseException {
		ArrayList<Object[]> result = new ArrayList<Object[]>();
		for(Object[] tuple : base.realize(g))
			if(constraint.contains(g, map(tuple)))
				result.add(tuple);
		return result;
	}

}
