/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.exception;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.VariableException;


public class MissingVariableValueException extends VariableException {

	private static final long serialVersionUID = -8379218573294565788L;
	
	public MissingVariableValueException(String message) {
		super(message);
	}

	public MissingVariableValueException(String message, Throwable cause) {
		super(message, cause);
	}

	public MissingVariableValueException(Throwable cause) {
		super(cause);
	}

	@Override
	public String getShortExplanation() {
		Throwable cause = getCause();
		if(cause instanceof DatabaseException) {
			return ((DatabaseException)cause).getShortExplanation();
		}
		return super.getShortExplanation();
	}
	
	@Override
	public String getExplanation(ReadGraph graph) throws DatabaseException {
		Throwable cause = getCause();
		if(cause instanceof DatabaseException) {
			return ((DatabaseException)cause).getShortExplanation();
		}
		return super.getShortExplanation();
	}
	
}
