/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.procedure.ListenerBase;

import gnu.trove.procedure.TIntProcedure;

public final class TypeHierarchy extends UnaryQueryP<IntSet> {

    TypeHierarchy(int resource) {
        super(resource);
    }

    public static final void queryEach(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        QueryCache.runnerTypeHierarchy(graph, r, parent, listener, procedure);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    @Override
    public void compute(final ReadGraphImpl graph, final InternalProcedure<IntSet> procedure) throws DatabaseException {
        computeForEach(graph, id, this, procedure);
    }

    public static IntSet computeForEach(ReadGraphImpl graph, int id, TypeHierarchy entry, final InternalProcedure<IntSet> procedure_) throws DatabaseException {

        InternalProcedure<IntSet> procedure = entry != null ? entry : procedure_;

        QueryProcessor processor = graph.processor;

        final IntSet result = new IntSet(processor.querySupport, id);

        final TIntProcedure addToResult = new TIntProcedure() {
            @Override
            public boolean execute(int r) {
            	result.add(r);
                return true;
            }
        };

        QueryCache.runnerSuperTypes(graph, id, entry, null, new InternalProcedure<IntSet>() {

            @Override
            public void execute(ReadGraphImpl graph, IntSet types) throws DatabaseException {
                types.forEach(addToResult);
                procedure.execute(graph, result); 
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                procedure.exception(graph, t);
            }

        });

        if(entry != null) entry.performFromCache(graph, procedure_);

        return result;

    }

    @Override
    public String toString() {
        return "TypeHierarchy[" + id + "]";
    }

}
