/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.common.exception.DebugException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.request.RequestFlags;

import gnu.trove.procedure.TIntProcedure;

final public class Predicates extends UnaryQueryP<IntSet> {

	Predicates(final int r) {
        super(r);
    }

 	@Override
 	final public void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
 	}
    
    final static private void forAssertions(ReadGraphImpl graph, int r, Predicates parent, final IntSet set) throws DatabaseException {

    	QueryCache.runnerPrincipalTypes(graph, r, parent, null, new SyncIntProcedure() {
            
            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
            }
            
            IntProcedure proc = new IntProcedure() {

                @Override
                public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                	set.add(i);
                }

                @Override
                public void finished(ReadGraphImpl graph) throws DatabaseException {
                    dec(graph);
                }
				
				@Override
				public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                    if(DebugException.DEBUG) new DebugException(t).printStackTrace();
	            }

            }; 

            @Override
            public void execute(ReadGraphImpl graph, int type) throws DatabaseException {

            	inc();
                QueryCache.runnerAssertedPredicates(graph, type, parent, null, proc);
                
            }
            
            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                dec(graph);       
            }
            
        });
        

    }

	@Override
	public void compute(ReadGraphImpl graph, final InternalProcedure<IntSet> procedure) throws DatabaseException {
		computeForEach(graph, id, this, procedure);
	}

	public static void computeForEach(ReadGraphImpl graph, final int r, final Predicates entry, final InternalProcedure<IntSet> procedure_) throws DatabaseException {
	    
	    InternalProcedure<IntSet> procedure = entry != null ? entry : procedure_;
    	
    	IntSet direct = QueryCache.resultDirectPredicates(graph, r, entry, null);
		
		IntSet result = new IntSet(graph.processor.querySupport);
    	forAssertions(graph, r, entry, result);
    	
    	if(result.isEmpty()) {
     		procedure.execute(graph, direct);
    	} else {
    		direct.forEach(new TIntProcedure() {
    			@Override
    			public boolean execute(int value) {
    				result.add(value);
    				return true;
    			}
    		});
     		procedure.execute(graph, result);
    	}
    	
    	if(entry != null) entry.performFromCache(graph, procedure_);
        
    }
    
    @Override
    public String toString() {
    	return "Predicates[" + id + "]";
    }

    @Override
    public void clearResult(QuerySupport support) {
    	setResult(new IntSet(support));
    }
    
    @Override
    public int type() {
        return RequestFlags.IMMEDIATE_UPDATE;
    }
    
}
