package org.simantics.db.impl.query;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

import org.simantics.utils.FileUtils;

public class CodeGen {

	int indent = 4;

	String[] signatureR1RelationInfo = { "int r", "r", "keyR", "long", "InternalProcedure<RelationInfo>", "entry.id" };
	String[] signatureR1Bytes = { "int r", "r", "keyR", "long", "InternalProcedure<byte[]>", "entry.id" };
	String[] signatureR1IntSet = { "int r", "r", "keyR", "long", "InternalProcedure<IntSet>", "entry.id" };
	String[] signatureR1IP = { "int r", "r", "keyR", "long", "IntProcedure", "entry.id" };
	String[] signatureR2IP = { "int r1, int r2", "r1,r2", "keyR2", "long", "IntProcedure", "entry.id" };
	String[] signatureR2TIP = { "int r1, int r2", "r1,r2", "keyR2", "long", "TripleIntProcedure", "entry.id" };
	String[] signatureID1 = { "String id", "id", "keyID", "String", "InternalProcedure<Integer>", "entry.id" };
	String[] signatureID2 = { "String id", "id", "keyID", "String", "InternalProcedure<TObjectIntHashMap<String>>", "entry.id" };
	String[] signatureChildMap = { "int r", "r", "keyR", "long", "InternalProcedure<ObjectResourceIdMap<String>>", "entry.id" };
	String[] signatureRead = { "Read<?> r", "r", "id", "long", "AsyncProcedure", "entry.request" };
	String[] signatureAsyncRead = { "AsyncRead<?> r", "r", "id", "long", "AsyncProcedure", "entry.request" };
	String[] signatureMultiRead = { "MultiRead<?> r", "r", "id", "long", "SyncMultiProcedure", "entry.request" };
	String[] signatureAsyncMultiRead = { "AsyncMultiRead<?> r", "r", "id", "long", "AsyncMultiProcedure", "entry.request" };
	String[] signatureExternalRead = { "ExternalRead<?> r", "r", "id", "long", "AsyncProcedure", "entry.request" };

	private void line(StringBuilder content, String line) {
		for(int i=0;i<indent;i++)
			content.append(" ");
		content.append(line);
		content.append("\n");
	}

    public void generateQuery(StringBuilder content, String clazz, String[] signature, boolean runnerShortcut, boolean genReturn) {
		generateGetOrCreate(content, clazz, signature);
		generateRemove(content, clazz, signature);
		generateRunner(content, clazz, signature, runnerShortcut, genReturn);
	}

	public void generateRunner(StringBuilder content, String clazz, String[] signature, boolean shortcut, boolean genReturn) {

		line(content, "public static " + (genReturn ? "Object" : "void") + " runner" + clazz + "(ReadGraphImpl graph, " + signature[0] + ", CacheEntry parent, ListenerBase listener, final " + signature[4] + " procedure) throws DatabaseException {");
		line(content, "    QueryCache cache  = graph.processor.cache;");
		if(shortcut) {
			line(content, "    if(parent == null && listener == null && !cache.shouldCache(graph.processor, " + signature[1] + ")) {");
			line(content, "        " + (genReturn ? "return " : "") + clazz + ".computeForEach(graph, " + signature[1] + ", null, procedure);");
			if(!genReturn) line(content, "        return;");
			line(content, "    }");
		}
		line(content, "    " + clazz + " entry = (" + clazz + ")cache.getOrCreate" + clazz + "(graph, " + signature[1] + ");");
		line(content, "    " + signature[4] + " procedure_ = procedure != null ? procedure : emptyProcedure" + clazz + ";");
		line(content, "    ListenerEntry listenerEntry = cache.registerDependencies(graph, entry, parent, listener, procedure_, false);");
		line(content, "    if(entry.isReady()) " + (genReturn ? "return " : "") + "entry.performFromCache(graph, procedure_);");
		line(content, "    else {");
		line(content, "      assert(entry.isPending());");
		if(shortcut) line(content, "      " + (genReturn ? "Object result = " : "") + clazz + ".computeForEach(graph, " + signature[1] + ", entry, procedure_);");
		else line(content, "      entry.compute(graph, procedure_);"); 
		line(content, "      if(listenerEntry != null) cache.primeListenerEntry(listenerEntry, entry.getResult());");
		if(genReturn) line(content, "      return result;");
		line(content, "    }");
		line(content, "}");
		line(content, "");

	}

	public void generateRemove(StringBuilder content, String clazz, String[] signature) {

		String lower = Character.toLowerCase(clazz.charAt(0)) + clazz.substring(1);

		line(content, "void remove(" + clazz + " entry) {");
		line(content, "    synchronized(" + lower + "Map) {");
		line(content, "        " + lower + "Map.remove(" + signature[5] + ");");
		line(content, "    }");
		line(content, "}");
		line(content, "");

	}

	public void generateGetOrCreate(StringBuilder content, String clazz, String[] signature) {

		String lower = Character.toLowerCase(clazz.charAt(0)) + clazz.substring(1);

		line(content, "" + clazz + " getOrCreate" + clazz + "(ReadGraphImpl graph, " + signature[0] + ") throws DatabaseException {");
		line(content, "    " + clazz + " existing = null;");
		line(content, "    synchronized(" + lower + "Map) {");
		line(content, "        existing = (" + clazz + ")" + lower + "Map.get(" + signature[1] + ");");
		line(content, "        if(existing == null) {");
		line(content, "            existing = new " + clazz + "(" + signature[1] + ");");
		line(content, "            existing.clearResult(querySupport);");
		line(content, "            existing.setPending();");
		line(content, "            " + lower + "Map.put(" + signature[2] + "(" + signature[1] + "), existing);");
		line(content, "            size++;");
		line(content, "            return existing;");
		line(content, "        }");
		line(content, "        if(existing.requiresComputation()) {");
		line(content, "            existing.setPending();");
		line(content, "            return existing;");
		line(content, "        }");
		line(content, "    }");
		line(content, "    if(existing.isPending()) waitPending(graph, existing);");
		line(content, "    return existing;");
		line(content, "}");
		line(content, "");

	}

	public void generate() {

		URL classLocation = CodeGen.class.getResource(".");
		if (classLocation != null) {
			if (classLocation.getProtocol().equals("file")) {
				try {
					URL resource = new URL(classLocation, ".");
					File path = new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
					String target = path.getAbsolutePath().replace("\\", "/");
					target = target.replace("/bin/", "/src/") + "/QueryCache.java";
					System.err.println("target=" + target);
					File source = new File(target);
					StringBuilder content = new StringBuilder();
					content.append("package org.simantics.db.impl.query;\n");
					content.append("\n");

					content.append("import org.simantics.db.ObjectResourceIdMap;\n");
					content.append("import org.simantics.db.RelationInfo;\n");
					content.append("import org.simantics.db.common.utils.Logger;\n");
					content.append("import org.simantics.db.exception.DatabaseException;\n");
					content.append("import org.simantics.db.impl.graph.ReadGraphImpl;\n");
					content.append("import org.simantics.db.impl.procedure.InternalProcedure;\n");
					content.append("import org.simantics.db.impl.query.QueryProcessor.SessionTask;\n");
					content.append("import org.simantics.db.procedure.AsyncMultiProcedure;\n");
					content.append("import org.simantics.db.procedure.AsyncProcedure;\n");
					content.append("import org.simantics.db.procedure.ListenerBase;\n");
					content.append("import org.simantics.db.procedure.SyncMultiProcedure;\n");
					content.append("import org.simantics.db.request.AsyncMultiRead;\n");
					content.append("import org.simantics.db.request.AsyncRead;\n");
					content.append("import org.simantics.db.request.ExternalRead;\n");
					content.append("import org.simantics.db.request.MultiRead;\n");
					content.append("import org.simantics.db.request.Read;\n");
					content.append("\n");

					content.append("public class QueryCache extends QueryCacheBase {\n");
					content.append("\n");
					line(content,"public QueryCache(QuerySupport querySupport, int threads) {");
					line(content,"    super(querySupport, threads);");
					line(content,"}");
					content.append("\n");

					generateQuery(content, "Objects", signatureR2IP, true, false);
					generateQuery(content, "Statements", signatureR2TIP, true, false);
					generateQuery(content, "DirectObjects", signatureR2IP, true, false);
					generateQuery(content, "RelationInfoQuery", signatureR1RelationInfo, true, false);
					generateQuery(content, "URIToResource", signatureID1, true, false);
					generateQuery(content, "ValueQuery", signatureR1Bytes, true, false);
					generateQuery(content, "OrderedSet", signatureR1IP, true, false);
					generateQuery(content, "PrincipalTypes", signatureR1IP, true, false);
					generateQuery(content, "DirectPredicates", signatureR1IntSet, true, false);
					generateQuery(content, "Predicates", signatureR1IntSet, true, false);
					generateQuery(content, "ReadEntry", signatureRead, true, true);
					generateQuery(content, "AsyncReadEntry", signatureAsyncRead, true, true);
					generateQuery(content, "Types", signatureR1IntSet, true, false);
					generateQuery(content, "ChildMap", signatureChildMap, true, false);
					generateQuery(content, "TypeHierarchy", signatureR1IntSet, true, false);
					generateQuery(content, "SuperTypes", signatureR1IntSet, true, false);
					generateQuery(content, "SuperRelations", signatureR1IntSet, true, false);

					generateQuery(content, "AssertedPredicates", signatureR1IP, false, false);
					generateQuery(content, "AssertedStatements", signatureR2TIP, false, false);
					generateQuery(content, "DirectSuperRelations", signatureR1IP, false, false);
					generateQuery(content, "MultiReadEntry", signatureMultiRead, false, false);
					generateQuery(content, "AsyncMultiReadEntry", signatureAsyncMultiRead, false, false);
					generateQuery(content, "ExternalReadEntry", signatureExternalRead, false, false);
					content.append("}\n");
					FileUtils.writeFile(source, content.toString().getBytes());
				} catch (MalformedURLException e) {
					e.printStackTrace();
				} catch (UnsupportedEncodingException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

	}

	public static void main(String[] args) {
		new CodeGen().generate();
	}

}
