/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.procedure.wrapper;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncSetListener;
import org.simantics.db.procedure.SyncSetListener;
import org.simantics.db.request.Read;

public final class SyncToAsyncSetProcedure<T>
implements AsyncSetListener<T> {
    private final SyncSetListener<T> procedure;

    public SyncToAsyncSetProcedure(SyncSetListener<T> procedure) {
        this.procedure = procedure;
    }

    public final void add(AsyncReadGraph graph, final T result) {
        graph.asyncRequest((Read)new ReadRequest(){

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                SyncToAsyncSetProcedure.this.procedure.add(graph, result);
            }

            public String toString() {
                return "Add [" + result + "] in " + SyncToAsyncSetProcedure.this.toString();
            }
        });
    }

    public final void remove(AsyncReadGraph graph, final T result) {
        graph.asyncRequest((Read)new ReadRequest(){

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                SyncToAsyncSetProcedure.this.procedure.remove(graph, result);
            }
        });
    }

    public final void exception(AsyncReadGraph graph, final Throwable t) {
        graph.asyncRequest((Read)new ReadRequest(){

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                SyncToAsyncSetProcedure.this.procedure.exception(graph, t);
            }
        });
    }

    public boolean isDisposed() {
        return this.procedure.isDisposed();
    }

    public String toString() {
        return "SyncToAsyncSetProcedure -> " + this.procedure;
    }
}

