/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.procedure.single.wrapper;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.procedure.AsyncProcedure;

public final class DeepSingleOrErrorProcedure<Result> {
    private Result result = null;
    final AsyncProcedure<Result> procedure;
    final AtomicBoolean done = new AtomicBoolean(false);
    final AtomicBoolean found = new AtomicBoolean(false);
    final AtomicInteger ready = new AtomicInteger(1);

    public DeepSingleOrErrorProcedure(AsyncProcedure<Result> procedure) {
        this.procedure = procedure;
    }

    public void inc() {
        this.ready.incrementAndGet();
    }

    public void dec(AsyncReadGraph graph) {
        if (this.ready.decrementAndGet() == 0 && this.done.compareAndSet(false, true)) {
            try {
                if (this.found.compareAndSet(false, true)) {
                    this.procedure.exception(graph, (Throwable)new NoSingleResultException("No results.", -1));
                } else {
                    this.procedure.execute(graph, this.result);
                }
            }
            catch (Throwable t) {
                Logger.defaultLogError(t);
            }
        }
    }

    public void offer(AsyncReadGraph graph, Result result) {
        if (this.found.compareAndSet(false, true)) {
            this.result = result;
        } else if (this.done.compareAndSet(false, true)) {
            try {
                this.procedure.exception(graph, (Throwable)new NoSingleResultException(this.result + " and " + result, -1));
            }
            catch (Throwable t) {
                Logger.defaultLogError(t);
            }
        }
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        if (this.done.compareAndSet(false, true)) {
            try {
                this.procedure.exception(graph, t);
            }
            catch (Throwable t2) {
                Logger.defaultLogError(t2);
            }
        }
    }
}

