/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

abstract public class TransientUnaryRead<P, R> extends BinaryRead<Object,P,R> {

	protected static final Object WITH_PARENT = new Object();
	
	public TransientUnaryRead(ReadGraph graph, P parameter) throws DatabaseException {
		this(graph, graph.getService(QueryControl.class), parameter);
	}
	
	public TransientUnaryRead(ReadGraph graph, QueryControl qc, P parameter) throws DatabaseException {
		super(resolveFirstParameter(graph, qc), parameter);
	}

	final private static Object resolveFirstParameter(ReadGraph graph, QueryControl qc) throws DatabaseException {
		if(qc.hasParentRequest(graph)) return WITH_PARENT;
		else return graph.getModificationCounter();
	}

	@Override
	final public R perform(ReadGraph _graph) throws DatabaseException {
		if(parameter == WITH_PARENT) {
			return perform(_graph, parameter2);
		} else {
			QueryControl qc = _graph.getService(QueryControl.class);
			ReadGraph graph = qc.getIndependentGraph(_graph);
			return perform(graph, parameter2);
		}
	}

	abstract public R perform(ReadGraph graph, P parameter) throws DatabaseException;
    
}
