/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.SyncSetListener;
import org.simantics.db.request.AsyncRead;

public abstract class SyncSetResourceRead<T> implements AsyncRead<Object>, SetListenerRead<T> {

    final protected SyncSetListener<T> procedure;
    final protected Resource resource;

    @Override
    public int hashCode() {
        return resource.hashCode() + 31 * procedure.hashCode();
    }
    
    @Override
    public int threadHash() {
    	return resource.getThreadHash();
    }
    
    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        SyncSetResourceRead<?> r = (SyncSetResourceRead<?>) object;
        return resource.equals(r.resource) && procedure.equals(r.procedure);
    }

    public SyncSetResourceRead(Resource resource, SyncSetListener<T> procedure) {
        this.resource = resource;
        this.procedure = procedure;
    }

    @Override
    public void perform(AsyncReadGraph graph, AsyncProcedure<Object> dummy) {
    	execute(graph, procedure);
    	dummy.execute(graph, null);
    }
    
}
