/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;

public class FreshName extends BinaryRead<Resource, String, String> {

    public FreshName(Resource container, String suggestion) {
        super(container, suggestion);
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {
        return NameUtils.findFreshName(graph, parameter2, parameter);
    }
    
}