/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.wrapper;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.AsyncSetListener;
import org.simantics.db.procedure.SetListener;

public class NoneToAsyncSetProcedure<T> implements AsyncSetListener<T> {

    final private SetListener<T> procedure;
    
    public NoneToAsyncSetProcedure(SetListener<T> procedure) {
        this.procedure = procedure;
    }
    
    @Override
    public void add(AsyncReadGraph graph, T t) {
        procedure.add(t);
    }

    @Override
    public void remove(AsyncReadGraph graph, T t) {
        procedure.remove(t);
    }

    @Override
    public void exception(AsyncReadGraph graph, Throwable t) {
        procedure.exception(t);
    }

    @Override
    public boolean isDisposed() {
        return procedure.isDisposed();
    }
    
    @Override
    public String toString() {
        return "NoneToAsyncSetProcedure -> " + procedure;
   }

}
