/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.SetResourceRead2;
import org.simantics.db.procedure.SyncSetListener;

final public class ForStatementSet extends SetResourceRead2<Statement> {

    public ForStatementSet(Resource resource, Resource resource2, SyncSetListener<Statement> procedure) {
        super(resource, resource2, procedure);
    }

    @Override
    public void execute(AsyncReadGraph graph, final SyncSetListener<Statement> procedure) {
        
    	graph.forStatementSet(resource, resource2, procedure);
    	
    }

}
