/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.util;

import java.util.Comparator;

public class NumberComparator implements Comparator<Number> {
	
	public static final NumberComparator INSTANCE = new NumberComparator();

	@Override
	public int compare(Number n1, Number n2) {
		boolean integerCompare = 
			(n1 instanceof Float==false) && 
			(n1 instanceof Double==false) && 
			(n2 instanceof Float==false) && 
			(n2 instanceof Double==false); 
		
		if (integerCompare) {
			long v1 = n1.longValue();
			long v2 = n2.longValue();
			return (v1>v2 ? -1 : (v1==v2 ? 0 : 1));
		} else {
			double v1 = n1.doubleValue();
			double v2 = n2.doubleValue();
			return (v1>v2 ? -1 : (v1==v2 ? 0 : 1));
		}
	}

}

