/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.file;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.simantics.databoard.binding.Binding;

/**
 * ListFile a {@link List} view to a random access file.
 * <p>
 * Note! 
 *   - {@link IOException}s are wrapped around {@link RuntimeIOException}.
 *   - The use of this class is not multi-thread safe.
 * 
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public interface IFileList<T> extends List<T> {
		
	/**
	 * Get the mapped file
	 * 
	 * @return file
	 */
	File getFile();
	
	/**
	 * Get class-data type binding  
	 * 
	 * @return the binding
	 */
	Binding getBinding();
	
    /**
     * Removes from this list all of the elements whose index is between
     * <code>fromIndex</code>, inclusive, and <code>toIndex</code>, exclusive.
     * Shifts any succeeding elements to the left (reduces their index).  This
     * call shortens the List by <code>(toIndex - fromIndex)</code> elements.  
     * (If <code>toIndex==fromIndex</code>, this operation has no effect.)<p>
     *
     * @param fromIndex the index of the first element to removed.
     * @param toIndex index after last element to be removed (exculsive).
     * 
     * @throws UnsupportedOperationException if the <code>remove</code> method is
     *		  not supported by this list.
     * @throws IndexOutOfBoundsException if the index is out of range (index
     *            &lt; 0 || index + count &gt;= size()).
     */
	void removeRange(int fromIndex, int toIndex);

    /**
     * Close the file
     */
    void close()
    throws IOException;
    
}

