package org.simantics.databoard.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;

public class ArgumentImpl implements Arguments {

	int hash;
	Class<?>[] args;
	
	public ArgumentImpl(Class<?>...args) {
        hash = Arrays.hashCode(args);
		this.args = args;
	}

	
	/**
	 * Drop first arguments from an argument list. 
	 * If all were dropped, null is returned.
	 *
	 * @param src source argument or null
	 * @param count argument count
	 * @return Argument or null.
	 */
	public static Arguments dropArguments(Arguments src, int count) {
		if (src==null) return null;
		int newLen = src.value().length - count;
		if (newLen<=0) return null;
		Class<?>[] newList = (Class<?>[]) Array.newInstance(Class.class, newLen);
		System.arraycopy(src.value(), count, newList, 0, newLen);
		return new ArgumentImpl(newList);
	}	
	
	@Override
	public Class<? extends Annotation> annotationType() {
		return Arguments.class;
	}

	@Override
	public Class<?>[] value() {
		return args;
	}
	
	@Override
	public int hashCode() {		
		return hash;
	}
	
	@Override
	public boolean equals(Object obj) {
		if ( obj instanceof Arguments == false ) return false;
		Arguments other = (Arguments) obj;
		Class<?>[] classArray1 = args;
		Class<?>[] classArray2 = other.value();
		
		return Arrays.deepEquals(classArray1, classArray2);
	}

}
