/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.interestset;

import org.simantics.databoard.type.DoubleType;

/**
 * Interest set of a Double Type.
 *
 * @see DoubleType
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class DoubleInterestSet extends InterestSet {

	public static final DoubleInterestSet MONITOR_EVERYTHING = new DoubleInterestSet(true, true); 
	
	/** Interested in notification (excludes the value) */
	public boolean notification = true;
	/** Interested in the value (includes notification) */  
	public boolean value = true;
	
	public DoubleInterestSet(boolean notification, boolean value) {
		this.notification = notification;
		this.value = value;
	}

	/**
	 * Returns true, if interested in notification. This does not include 
	 * interest in the value.
	 * 
	 * @return true if interested in notifications
	 */
	public boolean inNotifications() {
		return notification | value;
	}
	
	/**
	 * Returns true, if interested in the value  
	 * 
	 * @return true if interested in the value
	 */
	public boolean inValues() {
		return value;
	}
	
}

