/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.event;

import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.mutable.MutableVariant;

public class MapEntryAdded extends ModificationEvent {

	/** The key of the new entry. */
	public MutableVariant key; 
	/** The value of the new enry. Value is added if the entry was in interest Set */
	public @Optional MutableVariant value;

	public MapEntryAdded(ChildReference reference, MutableVariant key, MutableVariant value) {
		this.reference = reference;
		this.key = key;
		this.value = value;
	}
	
	public MapEntryAdded(MutableVariant key) {
		this.key = key;
	} 
	
	public MapEntryAdded(MutableVariant key, MutableVariant value) {
		this.key = key;
		this.value = value;
	} 
	
	@Override
	public MapEntryAdded clone(ChildReference newReference) {
		MapEntryAdded result = new MapEntryAdded(key, value);
		result.reference = newReference;
		return result;
	}		
	
	@Override
	public String toString() {
		return toRef()+" "+key+" = "+value;
	}	
	
}

