/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor;

import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.file.FileArrayAccessor;

public interface StreamAccessor extends ArrayAccessor, FileArrayAccessor, CloseableAccessor {

	void flush() throws AccessorException;
	
	/**
	 * Close the accessor.  
	 * 
	 * @throws AccessorException
	 */
	void close() throws AccessorException;
		
	/**
	 * Reset internal buffer. If there unwritten changes, they are flushed.
	 * 
	 * @throws AccessorException
	 */
	void reset() throws AccessorException;
	
}
