/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets.impl;

import org.eclipse.jface.resource.ResourceManager;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public interface WidgetSupport {

	/**
	 * The key for {@link #setParameter(String, Object)} used to associate a
	 * {@link ResourceManager} instance with this widget support context.
	 * Widgets that need to load resources (fonts, colors or images) need this.
	 */
	public static final String RESOURCE_MANAGER = "resourceManager";

	public static final Object NO_INPUT = new Object();
	
	/*
	 * The widget is set to receive input updates from this support
	 */
	void register(Widget widget);
	/*
	 * Updates will start only after this call
	 */
	void finish();
	/*
	 * Force update of widget
	 */
	void update(Widget widget);
	/*
	 * Force update of all widgets
	 */
	void update();
	/*
	 * Query current input
	 */
	<T> T getInput();
	
	<T> T getParameter(String key);
	void setParameter(String key, Object value);
	
	<T> T getInput(ReadGraph graph) throws DatabaseException;
	
}
