/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.SWTUtils;

public class Table extends WidgetImpl {

	private ReadFactory<?, List<Pair<String, Object>>> itemFactory;
	private ReadFactory<?, String> selectionFactory;
    private CopyOnWriteArrayList<SelectionListener> selectionListeners = new CopyOnWriteArrayList<SelectionListener>();

	final private org.eclipse.swt.widgets.Table table;
	
	public Table(Composite parent, WidgetSupport support, int style) {
		super(support);
		table = new org.eclipse.swt.widgets.Table(parent, style);
		table.setData("org.simantics.browsing.ui.widgets.Combo", this);
		support.register(this);
	}
	
	public void setItemFactory(ReadFactory<?, List<Pair<String, Object>>> itemFactory) {
		this.itemFactory = itemFactory;
	}

	public void setSelectionFactory(ReadFactory<?, String> selectionFactory) {
		this.selectionFactory = selectionFactory;
	}

	public org.eclipse.swt.widgets.Table getWidget() {
		return table;
	}
	
	@Override
	public Control getControl() {
		return table;
	}

	@Override
	public void setInput(ISessionContext context, Object input) {

        if (selectionListeners != null) {
            for (SelectionListener listener : selectionListeners) {
            	if(listener instanceof Widget) {
                    ((Widget) listener).setInput(context, input);
            	}
            }
        }
		
		if(itemFactory != null) {
			itemFactory.listen(context, input, new Listener<List<Pair<String, Object>>>() {

				@Override
				public void exception(Throwable t) {
					t.printStackTrace();
				}

				@Override
				public void execute(final List<Pair<String, Object>> items) {
					SWTUtils.asyncExec(table, new Runnable() {

						@Override
						public void run() {
							if(isDisposed()) return;
//							System.out.println("Combo received new items: " + items.size());
							for(SelectionListener listener : selectionListeners) table.removeSelectionListener(listener);
							table.setData(items);
							try {
								table.removeAll();
							} catch (Throwable t) {
								t.printStackTrace();
							}
							//table.setItemCount(items.size());
							for(Pair<String, Object> key : items) {
								TableItem item = new TableItem (table, SWT.NONE);
								item.setText(key.first);
								item.setData(key.second);
							}
							String selectionKey = (String)table.getData("_SelectionKey");
							if(selectionKey != null) {
								Integer selectionIndex = (Integer)table.getData(selectionKey);
								if(selectionIndex != null) table.select(selectionIndex);
							}
							for(SelectionListener listener : selectionListeners) table.addSelectionListener(listener);
							
							//label.setSize(200, 20);
//							label.getParent().layout();
//							label.getParent().getParent().layout();
						}

					});
				}

				@Override
				public boolean isDisposed() {
					return table.isDisposed();
				}

			});
		}

		if(selectionFactory != null) {
			selectionFactory.listen(context, input, new Listener<String>() {

				@Override
				public void exception(Throwable t) {
					t.printStackTrace();
				}

				@Override
				public void execute(final String selectionKey) {
					SWTUtils.asyncExec(table, new Runnable() {

						@Override
						public void run() {
							if(isDisposed()) return;
							if(selectionKey == null) return;
//							System.out.println("Combo received new selection key: " + selectionKey);
							
							table.setData("_SelectionKey", selectionKey);
							Integer selectionIndex = (Integer)table.getData(selectionKey);
							if(selectionIndex != null) table.select(selectionIndex);
							
						}

					});
				}

				@Override
				public boolean isDisposed() {
					return table.isDisposed();
				}

			});
		}
		
	}

    public synchronized void addSelectionListener(SelectionListener listener) {
        selectionListeners.add(listener);
		table.addSelectionListener(listener);
    }
	
}
