/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.ui.IViewPart;
import org.simantics.browsing.ui.common.views.IViewArguments;

/**
 * Utilities for parsing what is specified in {@link IViewArguments}.
 */
public class ViewArgumentUtils {

    private static final Pattern argumentPattern = Pattern.compile("([^:&=]*)=([^:&=]*)");

    public static Map<String, String> parseViewArguments(IViewPart part) {
        String secondaryId = part.getViewSite().getSecondaryId();
        Map<String, String> result = ViewArgumentUtils.decodeArguments(secondaryId);
        return result;
    }    

    public static Map<String, String> decodeArguments(String secondaryId) {
        Map<String, String> result = new HashMap<String, String>();
        if (secondaryId == null)
            return result;

        String[] args = secondaryId.split("&");
        for (String arg : args) {
            Matcher m = argumentPattern.matcher(arg);
            if (m.matches()) {
                String key = m.group(1);
                String value = m.group(2);

                key = unescape(key);
                value = unescape(value);

                result.put(key, value);
            }
        }
        return result;
    }

    public static String encodeArguments(Map<String, String> args) {
        StringBuilder sb = new StringBuilder();
        boolean notFirst = false;
        for (Map.Entry<String, String> e : args.entrySet()) {
            if (notFirst)
                sb.append("&");
            notFirst = true;
            String key = e.getKey();
            String value = e.getValue();
            sb.append(escape(key));
            sb.append("=");
            sb.append(escape(value));
        }
        return sb.toString();
    }

    private static String escape(String s) {
        return s.replace("&", "%26").replace(":", "%3A").replace("=", "%3D");
    }

    private static String unescape(String s) {
        return s.replace("%26", "&").replace("%3A", ":").replace("%3D", "=");
    }

}
