/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;

public class ModelledWizardPageImpl implements ModelledWizardPage {

	final private Resource configuration;
	
	public ModelledWizardPageImpl(Resource configuration) {
		this.configuration = configuration;
	}

	class Page extends WizardPage {

		final private WidgetSupport support;
		
		public Page(String title, WidgetSupport support) {
			super(title, title, null);
			this.support = support;
		}
		
		@Override
		public void createControl(Composite parent) {

			try {

				ModelledControl modelledControl = Simantics.getSession().syncRequest(new Read<ModelledControl>() {
					@Override
					public ModelledControl perform(ReadGraph graph) throws DatabaseException {
						BrowsingResource BRO = BrowsingResource.getInstance(graph);
						Resource controlResource = graph.getPossibleObject(configuration, BRO.WizardPage_Control);
						return graph.adapt(controlResource, ModelledControl.class);
					}
				});

				Control control = modelledControl.create(parent, null, null, support);

				setControl(control);

			} catch (DatabaseException e) {
				
				e.printStackTrace();
				
			}
			
		}
		
	}
	
	public IWizardPage create(ISessionContext context, WidgetSupport support) throws DatabaseException {

		String title = Simantics.getSession().syncRequest(new Read<String>() {
			@Override
			public String perform(ReadGraph graph) throws DatabaseException {
				BrowsingResource br = BrowsingResource.getInstance(graph);
				return graph.getPossibleRelatedValue(configuration, br.WizardPage_Title, Bindings.STRING);
			}
		});

		return new Page(title, support);
		
	}
	
}
