/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;

/**
 * @author Tuukka Lehtonen
 */
public class ModelledDialog implements ModelledAction {

	public class DialogImpl extends Dialog {

	    private final WidgetSupport          widgetSupport;
	    private Runnable               finishAction;
	    
	    private final String title;

	    public DialogImpl(Shell shell, WidgetSupport support, String title) {
	    	super(shell);
	    	this.title = title;
	    	this.widgetSupport = support;
	    }

	    @Override
	    protected void configureShell(Shell shell) {
	        super.configureShell(shell);
	        if (title != null) {
				shell.setText(title);
			}
	    }
	    
	    @Override
	    protected boolean isResizable() {
	    	return true;
	    }
	    
	    @Override
	    protected void okPressed() {
    		if(finishAction != null) finishAction.run();
    		super.okPressed();
	    }
	    
		protected Control createDialogArea(Composite parent) {
			
			Composite composite = (Composite)super.createDialogArea(parent);
			
			try {
			
				ModelledControl modelledControl = Simantics.getSession().syncRequest(new Read<ModelledControl>() {
					@Override
					public ModelledControl perform(ReadGraph graph) throws DatabaseException {
						BrowsingResource BRO = BrowsingResource.getInstance(graph);
						Resource controlResource = graph.getPossibleObject(configuration, BRO.Dialog_Control);
						return graph.adapt(controlResource, ModelledControl.class);
					}
				});
				
				ModelledAction finishAction = Simantics.getSession().syncRequest(new Read<ModelledAction>() {
					@Override
					public ModelledAction perform(ReadGraph graph) throws DatabaseException {
						BrowsingResource BRO = BrowsingResource.getInstance(graph);
						Resource actionResource = graph.getPossibleObject(configuration, BRO.Dialog_FinishAction);
						return graph.adapt(actionResource, ModelledAction.class);
					}
				}); 
				
				this.finishAction = finishAction.create(null, null, widgetSupport);
				
				return modelledControl.create(composite, null, null, widgetSupport);
			
			} catch (DatabaseException e) {
				
				e.printStackTrace();
				
			}
			
			return composite;
			
		}
		
		@Override
		protected Control createContents(Composite parent) {
			return super.createContents(parent);
		}
		
	}
	
	
	final Resource configuration;
	
    public ModelledDialog(Resource configuration) {
        this.configuration = configuration;
    }

	@Override
	public Runnable create(IWorkbenchSite site, ISessionContext context, final WidgetSupport support) throws DatabaseException {

		final String title = Simantics.getSession().syncRequest(new Read<String>() {

			@Override
			public String perform(ReadGraph graph) throws DatabaseException {
				BrowsingResource br = BrowsingResource.getInstance(graph);
				return graph.getPossibleRelatedValue(configuration, br.Dialog_Title, Bindings.STRING);
			}
			
		});
		
		return new Runnable() {

			@Override
			public void run() {
				
				DialogImpl dialog = new DialogImpl(Display.getCurrent().getActiveShell(), support, title);
			    dialog.create();
			    support.update();
			    dialog.open();				
				
			}
			
		};
		
	}

}
