/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.Collections;
import java.util.List;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;

public class ModelledComposite implements ModelledControl {

	final private Resource configuration;
	
	public ModelledComposite(Resource configuration) {
		this.configuration = configuration;
	}
	
	@Override
	public Composite create(Composite parent, IWorkbenchSite site, ISessionContext context, WidgetSupport support) throws DatabaseException {
		
    	Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

		Layout layout = Simantics.getSession().syncRequest(new Read<Layout>() {

			@Override
			public Layout perform(ReadGraph graph) throws DatabaseException {

				BrowsingResource br = BrowsingResource.getInstance(graph);
				Integer columns = graph.getPossibleRelatedValue(configuration, br.Composite_ColumnCount, Bindings.INTEGER);
				
				GridLayout layout = GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(0, 0).spacing(0, 0).create();
				if(columns != null) layout.numColumns = columns;
				
				return layout;
				
			}
			
		});
		
		composite.setLayout(layout);
		
//		GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).margins(0, 0).spacing(0, 0).applyTo(composite);
		
		List<Resource> children = Simantics.getSession().syncRequest(new Read<List<Resource>>() {

			@Override
			public List<Resource> perform(ReadGraph graph) throws DatabaseException {
				BrowsingResource br = BrowsingResource.getInstance(graph);
				Resource tabList = graph.getPossibleObject(configuration, br.Composite_Children);
				if(tabList == null) return Collections.emptyList();
				return OrderedSetUtils.toList(graph, tabList);
			}
			
		});

		for(final Resource child : children) {

			ModelledControl control = Simantics.getSession().syncRequest(new PossibleAdapter<ModelledControl>(child, ModelledControl.class));			
			control.create(composite, site, context, support);
			
		}

		return composite;
		
	}
	
}
