/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.processors.AbstractPrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.processors.ProcessorLifecycle;
import org.simantics.browsing.ui.common.processors.ShowMaxChildrenProcessor;

/**
 * @author Tuukka Lehtonen
 */
public class DefaultShowMaxChildrenProcessor extends AbstractPrimitiveQueryProcessor<Integer> implements
        ShowMaxChildrenProcessor, ProcessorLifecycle {

    private final Integer MAX_INT = Integer.MAX_VALUE;

    /**
     * The set of currently expanded node contexts.
     */
    private final TObjectIntHashMap<NodeContext>               showMaxChildren        = new TObjectIntHashMap<NodeContext>();
    private final THashMap<NodeContext, PrimitiveQueryUpdater> showMaxChildrenQueries = new THashMap<NodeContext, PrimitiveQueryUpdater>();

    public DefaultShowMaxChildrenProcessor() {
    }

    @Override
    public Object getIdentifier() {
        return BuiltinKeys.SHOW_MAX_CHILDREN;
    }

    @Override
    public String toString() {
        return "ShowMaxChildrenProcessor";
    }

    @Override
    public Integer query(PrimitiveQueryUpdater updater, NodeContext context, PrimitiveQueryKey<Integer> key) {
        int maxChildren = showMaxChildren.get(context);
        //System.out.println("maxChildren(" + updater + ", " + context + "): " + maxChildren);
        showMaxChildrenQueries.put(context, updater);
        if (maxChildren == 0)
            return null;
        return Integer.valueOf(maxChildren);
    }

    @Override
    public boolean setShowMaxChildren(NodeContext context, int maxChildren) {
        return _setShowMaxChildren(context, maxChildren);
    }

    @Override
    public boolean replaceShowMaxChildren(NodeContext context, int maxChildren) {
        return nodeStatusChanged(context, maxChildren);
    }

    private boolean _setShowMaxChildren(NodeContext context, int maxChildren) {
        if (maxChildren > 0) {
            return this.showMaxChildren.put(context, maxChildren) != maxChildren;
        } else {
            return this.showMaxChildren.remove(context) != 0;
        }
    }

    protected boolean nodeStatusChanged(NodeContext context, int maxChildren) {
        boolean result = _setShowMaxChildren(context, maxChildren);
        PrimitiveQueryUpdater updater = showMaxChildrenQueries.get(context);
        if (updater != null) {
            Integer newValue = null;
            if (maxChildren > 0) {
                if (maxChildren != Integer.MAX_VALUE)
                    newValue = Integer.valueOf(maxChildren);
                else
                    newValue = MAX_INT;
            }
            updater.scheduleReplace(context, BuiltinKeys.SHOW_MAX_CHILDREN, newValue);
        }
        return result;
    }

    @Override
    public void attached(GraphExplorer explorer) {
    }

    @Override
    public void detached(GraphExplorer explorer) {
        clear();
    }

    @Override
    public void clear() {
        showMaxChildren.clear();
        showMaxChildrenQueries.clear();
    }

}