/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.BuiltinKeys.CheckedStateKey;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.Preference;
import org.simantics.browsing.ui.common.EvaluatorData.Evaluator;
import org.simantics.browsing.ui.common.EvaluatorData.EvaluatorTree;
import org.simantics.browsing.ui.content.CheckedStateFactory;
import org.simantics.utils.datastructures.collections.CollectionUtils;

/**
 * @author Antti Villberg
 */
public class DefaultIsCheckedProcessor2 implements NodeQueryProcessor<CheckedState> {

    private final EvaluatorData data;

    public DefaultIsCheckedProcessor2(EvaluatorData data) {
        this.data = data;
    }

    @Override
    public QueryKey<CheckedState> getIdentifier() {
    	return BuiltinKeys.IS_CHECKED;
    }

    @Override
    public CheckedState query(final NodeQueryManager manager, final NodeContext context) {
        assert context != null;

        Object input = context.getConstant(BuiltinKeys.INPUT);
        assert input != null;

        Collection<Evaluator> evals = data.get(input);
        if (evals.isEmpty())
            return null;

        ArrayList<Preference<CheckedStateFactory>> factories = new ArrayList<Preference<CheckedStateFactory>>(4);
        for (Evaluator eval : evals) {
            evaluateTree(manager, context, eval.getCheckStateTree(), factories);
        }

        if (factories.isEmpty())
            return null;

        if (factories.size() >= 1) {
            Collections.sort(factories);
            return manager.query(context, new CheckedStateKey(factories.get(0).object));
        } else {
        	return null;
        }

    }

    protected void evaluateTree(NodeQueryManager manager, NodeContext context, EvaluatorTree<CheckedStateFactory> tree, Collection<Preference<CheckedStateFactory>> result) {
        Tester test = tree.getTester();

        if (test.test(manager, context)) {
            CollectionUtils.checkedAdd(tree.getAcceptedFactories(), result);

            Collection<EvaluatorTree<CheckedStateFactory>> children = tree.getChildren();
            if (children == null)
                return;
            for (EvaluatorTree<CheckedStateFactory> e : children) {
                evaluateTree(manager, context, e, result);
            }
        }
    }
    
    @Override
    public String toString() {
        return "IsCheckedProcessor";
    }

}