/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.labels;

import java.util.Collections;
import java.util.Map;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.PendingVariableException;

public class LabelContribution
extends VisualsContribution {
    LabelRule labelRule;

    public LabelContribution(NodeType nodeType, Test test, LabelRule labelRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if (!labelRule.isCompatible(nodeType.getContentType())) {
            throw new InvalidContribution("Label rule is not compatible with the content type.");
        }
        this.labelRule = labelRule;
    }

    public Map<String, String> getLabel(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if (this.test == null || this.test.test(graph, content)) {
                return this.labelRule.getLabel(graph, content);
            }
            return null;
        }
        catch (PendingVariableException pendingVariableException) {
            return Collections.singletonMap("single", "");
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return Collections.singletonMap("single", "");
        }
    }
}

