/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.tests;

import org.eclipse.core.runtime.Platform;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 * @since 1.30.0
 */
public enum InDevelopmentModeTest implements Test {
    INSTANCE;

    public static InDevelopmentModeTest get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return true;
    }

    @Override
    public boolean test(ReadGraph graph, Object content) throws DatabaseException {
        return Platform.inDevelopmentMode();
    }

}
