/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.nodetypes;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.ConstantKey;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.selection.WorkbenchSelectionElement;

/**
 * Node type specifies the content type and role of the node in 
 * the model browser.
 * @author Hannu Niemistö
 */
public interface NodeType {

    public static class TypeKey implements ConstantKey<NodeType> {
        private TypeKey() {}
        @Override
        public String toString() {
            return "TYPE";
        }
    };
    public static final ConstantKey<NodeType> TYPE = new TypeKey();

    public static final ConstantKey<?>[] KEY_SEQUENCE = new ConstantKey<?>[] {
        BuiltinKeys.INPUT,
        TYPE
    };

    public static final ConstantKey<?>[] KEY_SEQUENCE_EXT = new ConstantKey<?>[] {
        BuiltinKeys.INPUT,
        TYPE,
        BuiltinKeys.UI_CONTEXT,
        BuiltinKeys.BROWSE_CONTEXT,
        BuiltinKeys.ACTION_BROWSE_CONTEXT
    };
    
    /**
     * Creates a node context from the content. If the content is not
     * suitable for this node type, returns null. This method cannot
     * assume anything about the Java type of the content given as
     * a parameter, but if it returns a node its content must be 
     * an instance of the Java class given by getContentType.
     */
    NodeContext createNodeContext(ReadGraph graph, Object content) throws DatabaseException;
    
    /**
     * Returns the expected Java type of the content.
     */
    Class<?> getContentType();
    
    /**
     * Tests if this node type inherits (or is equal to) given node type.
     */
    boolean inherits(ReadGraph graph, NodeType superType) throws DatabaseException;

    Collection<NodeType> getSuper(ReadGraph g) throws DatabaseException;

    String toString(ReadGraph graph) throws DatabaseException; 
    
    WorkbenchSelectionElement getWorkbenchSelectionElement(NodeContext context);
}
