/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.labeldecorators;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Constant label rule gives a fixed label to a node.
 * @author Hannu Niemistö
 */
public class ForegroundColorDecorationRule extends AbstractLabelDecorator implements LabelDecorationRule {

    ColorDescriptor color;
    
    public ForegroundColorDecorationRule(RGB rgb) {
        this(ColorDescriptor.createFrom(rgb));
    }
    
    public ForegroundColorDecorationRule(ColorDescriptor color) {
        this.color = color;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return true;
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content)
            throws DatabaseException {
        return this;
    }
    
    @SuppressWarnings("unchecked")
    public <Color> Color decorateForeground(Color color, String column, int itemIndex) {
        return (Color)this.color;
    }

}
