/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.SelectedViewpointFactoryKey;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.content.ViewpointFactory;

public class DefaultSelectedViewpointFactoryProcessor extends AbstractPrimitiveQueryProcessor<ViewpointFactory> {

    @Override
    public Object getIdentifier() {
        return BuiltinKeys.SelectedViewpointFactoryKey.class;
    }

    @Override
    public String toString() {
        return "SelectedViewpointFactoryProcessor";
    }

    @Override
    public ViewpointFactory query(PrimitiveQueryUpdater updater, NodeContext context,
            PrimitiveQueryKey<ViewpointFactory> key) {
        SelectedViewpointFactoryKey k = (SelectedViewpointFactoryKey) key;
        Collection<ViewpointFactory> factories = k.getParameter(0);
        if (factories.isEmpty())
            return null;

        return factories.iterator().next();
    }

}