/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.labelers;

import java.util.Collections;
import java.util.Map;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.GraphExplorer.ModificationContext;
import org.simantics.browsing.ui.content.Labeler;

/**
 * @author Antti Villberg
 */
public class ToStringLabeler implements Labeler {

    final private String string;

    public ToStringLabeler(NodeContext context) {
        string = context.getConstant(BuiltinKeys.INPUT).toString();
    }

    @Override
    public Map<String, String> getLabels() {
        return Collections.singletonMap("single", string);
    }
    @Override
    public Map<String, String> getRuntimeLabels() {
        return Collections.emptyMap();
    }
    @Override
    public int getCategory() {
        return 0;
    }
    @Override
    public Modifier getModifier(ModificationContext modificationContext, String key) {
        return null;
    }
    @Override
    public void setListener(LabelerListener listener) {
        // Intentionally blank, cannot implement listening.
    }

}
