/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.extension.internal;

import org.simantics.browsing.ui.content.CheckedStateFactory;
import org.simantics.browsing.ui.content.Contributor;

/**
 * @author Tuukka Lehtonen
 */
public class CheckedStateContributorExtensionManager extends ContributorExtensionManager<CheckedStateFactory> {

    public String getExtensionPointName() {
    	return "checkedState";
    }
	
    private static CheckedStateContributorExtensionManager INSTANCE;

    public static synchronized CheckedStateContributorExtensionManager getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CheckedStateContributorExtensionManager();
        return INSTANCE;
    }


    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }
    
    public static Contributor<CheckedStateFactory> getFactory(String id) {
        for(ContributorExtension<CheckedStateFactory> ext : getInstance().extensions) {
            if(ext.getFactory().getClass().getCanonicalName().equals(id)) return ext.getFactory();
        }
        return null;
    }

}
