/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.contributor;

import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.utils.ReflectionUtils;

/**
 * @author Tuukka Lehtonen
 *
 * @param <T> input object types to use this comparable contributor for
 */
public abstract class ComparableContributorImpl<T> implements Contributor<ComparableContextFactory> {

    private final Class<?> clazz;

    public ComparableContributorImpl() {
        this.clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    public ComparableContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

    @Override
    public abstract ComparableContextFactory getFactory();

}
