/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common;

import org.simantics.browsing.ui.content.Labeler;
import org.simantics.utils.datastructures.ArrayMap;

/**
 * Reusable standard key objects for idenfitying columns in {@link Labeler}
 * implementations.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see Labeler#getLabels()
 * @see Labeler#getRuntimeLabels()
 */
public final class ColumnKeys {

    // Use these for single-column tree views

    public static final String   SINGLE              = "single";

    /**
     * Use with {@link ArrayMap} in {@link Labeler} implementations.
     */
    public static final String[] KEYS_SINGLE         = { SINGLE };

    // Use these for tree-table style multicolumn views

    public static final String   PROPERTY            = "Property";

    public static final String   EXPRESSION               = "Expression";

    public static final String   VALUE               = "Value";

    public static final String   DISPLAY_PROPERTY            = "HasDisplayProperty";
    public static final String   DISPLAY_VALUE            = "HasDisplayValue";
    public static final String   DISPLAY_UNIT            = "HasDisplayUnit";

    
    /**
     * Use with {@link ArrayMap} in {@link Labeler} implementations.
     */
    public static final String[] KEYS_PROPERTY_VALUE = { PROPERTY, VALUE };
    
}
