/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common;

import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.Column.Align;

/**
 * A factory for constructing new {@link Column} instances in chained
 * initialization coding style. The same factory can be used to create any
 * number of new {@link Column} instances.
 * 
 * @see Column
 * 
 * @author Tuukka Lehtonen
 */
public class ColumnFactory {

    String key;

    String label;

    Align alignment;

    int    width;

    String tooltip;

    boolean grab = false;

    private ColumnFactory(String key) {
        this.key = key;
        this.alignment = Align.LEFT;
        this.width = Column.DEFAULT_CONTROL_WIDTH;
        this.tooltip = "";
    }

    private ColumnFactory(String key, Align alignment, int width, String tooltip) {
        this.key = key;
        this.alignment = alignment;
        this.width = width;
        this.tooltip = tooltip;
    }

    public static ColumnFactory defaults(String key) {
        return new ColumnFactory(key);
    }

    public static ColumnFactory get(Column c) {
        return new ColumnFactory(c.getKey(), c.getAlignment(), c.getWidth(), c.getTooltip());
    }

    public ColumnFactory key(String key) {
        this.key = key;
        return this;
    }

    public ColumnFactory label(String label) {
        this.label = label;
        return this;
    }

    public ColumnFactory alignment(Align alignment) {
        this.alignment = alignment;
        return this;
    }

    public ColumnFactory width(int width) {
        this.width = width;
        return this;
    }

    public ColumnFactory tooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ColumnFactory grab() {
        this.grab = true;
        return this;
    }

    public Column toColumn() {
        return new Column(key, label, alignment, width, tooltip, grab);
    }

}
