/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common;

import java.net.URL;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends Plugin {

    // The plug-in ID
    public static final String PLUGIN_ID = "org.simantics.browsing.ui.common";

    /** Error logger */
    private ErrorLogger errorLogger = new ErrorLogger(this);
    
    private static Activator plugin;
    
    /* (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    public void start(BundleContext context) throws Exception {
    	super.start(context);
    	plugin = this;
    }

    /* (non-Javadoc)
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    public void stop(BundleContext context) throws Exception {
    	super.stop(context);
    	plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }
    
    public static URL getDefaultResource(String name) {
    	Activator plugin = getDefault();
    	if(plugin == null) throw new IllegalStateException("The plugin is not active.");
    	return plugin.getBundle().getResource(name);
    }
    
    public ErrorLogger getErrorLogger() {
        return errorLogger;
    }  
    
}
