/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve.protocol;

import java.io.InputStream;
import java.io.OutputStream;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.protocol.RPacket;

public class RTalk {
    public static final int DT_INT = 1;
    public static final int DT_CHAR = 2;
    public static final int DT_DOUBLE = 3;
    public static final int DT_STRING = 4;
    public static final int DT_BYTESTREAM = 5;
    public static final int DT_SEXP = 10;
    public static final int DT_ARRAY = 11;
    public static final int DT_LARGE = 64;
    public static final int CMD_login = 1;
    public static final int CMD_voidEval = 2;
    public static final int CMD_eval = 3;
    public static final int CMD_shutdown = 4;
    public static final int CMD_openFile = 16;
    public static final int CMD_createFile = 17;
    public static final int CMD_closeFile = 18;
    public static final int CMD_readFile = 19;
    public static final int CMD_writeFile = 20;
    public static final int CMD_removeFile = 21;
    public static final int CMD_setSEXP = 32;
    public static final int CMD_assignSEXP = 33;
    public static final int CMD_setBufferSize = 129;
    public static final int CMD_setEncoding = 130;
    public static final int CMD_detachSession = 48;
    public static final int CMD_detachedVoidEval = 49;
    public static final int CMD_attachSession = 50;
    public static final int CMD_ctrlEval = 66;
    public static final int CMD_ctrlSource = 69;
    public static final int CMD_ctrlShutdown = 68;
    public static final int ERR_auth_failed = 65;
    public static final int ERR_conn_broken = 66;
    public static final int ERR_inv_cmd = 67;
    public static final int ERR_inv_par = 68;
    public static final int ERR_Rerror = 69;
    public static final int ERR_IOerror = 70;
    public static final int ERR_not_open = 71;
    public static final int ERR_access_denied = 72;
    public static final int ERR_unsupported_cmd = 73;
    public static final int ERR_unknown_cmd = 74;
    public static final int ERR_data_overflow = 75;
    public static final int ERR_object_too_big = 76;
    public static final int ERR_out_of_mem = 77;
    public static final int ERR_ctrl_closed = 78;
    public static final int ERR_session_busy = 80;
    public static final int ERR_detach_failed = 81;
    InputStream is;
    OutputStream os;

    public RTalk(InputStream sis, OutputStream sos) {
        this.is = sis;
        this.os = sos;
    }

    public static void setInt(int v, byte[] buf, int o) {
        buf[o] = (byte)(v & 0xFF);
        buf[++o] = (byte)((v & 0xFF00) >> 8);
        buf[++o] = (byte)((v & 0xFF0000) >> 16);
        buf[++o] = (byte)((v & 0xFF000000) >> 24);
    }

    public static int setHdr(int ty, int len, byte[] buf, int o) {
        buf[o] = (byte)(ty & 0xFF | (len > 0xFFFFF0 ? 64 : 0));
        buf[++o] = (byte)(len & 0xFF);
        buf[++o] = (byte)((len & 0xFF00) >> 8);
        buf[++o] = (byte)((len & 0xFF0000) >> 16);
        ++o;
        if (len > 0xFFFFF0) {
            buf[o] = (byte)((len & 0xFF000000) >> 24);
            buf[++o] = 0;
            buf[++o] = 0;
            buf[++o] = 0;
            ++o;
        }
        return o;
    }

    public static byte[] newHdr(int ty, int len) {
        byte[] hdr = new byte[len > 0xFFFFF0 ? 8 : 4];
        RTalk.setHdr(ty, len, hdr, 0);
        return hdr;
    }

    public static int getInt(byte[] buf, int o) {
        return buf[o] & 0xFF | (buf[o + 1] & 0xFF) << 8 | (buf[o + 2] & 0xFF) << 16 | (buf[o + 3] & 0xFF) << 24;
    }

    public static int getLen(byte[] buf, int o) {
        return (buf[o] & 0x40) > 0 ? buf[o + 1] & 0xFF | (buf[o + 2] & 0xFF) << 8 | (buf[o + 3] & 0xFF) << 16 | (buf[o + 4] & 0xFF) << 24 : buf[o + 1] & 0xFF | (buf[o + 2] & 0xFF) << 8 | (buf[o + 3] & 0xFF) << 16;
    }

    public static long getLong(byte[] buf, int o) {
        long low = (long)RTalk.getInt(buf, o) & 0xFFFFFFFFL;
        long hi = (long)RTalk.getInt(buf, o + 4) & 0xFFFFFFFFL;
        hi <<= 32;
        return hi |= low;
    }

    public static void setLong(long l, byte[] buf, int o) {
        RTalk.setInt((int)(l & 0xFFFFFFFFL), buf, o);
        RTalk.setInt((int)(l >> 32), buf, o + 4);
    }

    public RPacket request(int cmd) {
        byte[] d = new byte[]{};
        return this.request(cmd, d);
    }

    public RPacket request(int cmd, byte[] cont) {
        return this.request(cmd, null, cont, 0, cont == null ? 0 : cont.length);
    }

    public RPacket request(int cmd, byte[] prefix, byte[] cont, int offset, int len) {
        byte[] ih;
        block16: {
            int contlen;
            if (cont != null) {
                if (offset >= cont.length) {
                    cont = null;
                    len = 0;
                } else if (len > cont.length - offset) {
                    len = cont.length - offset;
                }
            }
            if (offset < 0) {
                offset = 0;
            }
            if (len < 0) {
                len = 0;
            }
            int n = contlen = cont == null ? 0 : len;
            if (prefix != null && prefix.length > 0) {
                contlen += prefix.length;
            }
            byte[] hdr = new byte[16];
            RTalk.setInt(cmd, hdr, 0);
            RTalk.setInt(contlen, hdr, 4);
            int i = 8;
            while (i < 16) {
                hdr[i] = 0;
                ++i;
            }
            if (cmd != -1) {
                this.os.write(hdr);
                if (prefix != null && prefix.length > 0) {
                    this.os.write(prefix);
                }
                if (cont != null && cont.length > 0) {
                    this.os.write(cont, offset, len);
                }
            }
            if (this.is.read(ih = new byte[16]) == 16) break block16;
            return null;
        }
        try {
            int rep = RTalk.getInt(ih, 0);
            int rl = RTalk.getInt(ih, 4);
            if (rl > 0) {
                byte[] ct = new byte[rl];
                int n = 0;
                while (n < rl) {
                    int rd = this.is.read(ct, n, rl - n);
                    n += rd;
                }
                return new RPacket(rep, ct);
            }
            return new RPacket(rep, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public RPacket request(int cmd, String par) {
        try {
            byte[] b = par.getBytes(RConnection.transferCharset);
            int sl = b.length + 1;
            if ((sl & 3) > 0) {
                sl = (sl & 0xFFFFFC) + 4;
            }
            byte[] rq = new byte[sl + 5];
            int i = 0;
            while (i < b.length) {
                rq[i + 4] = b[i];
                ++i;
            }
            while (i < sl) {
                rq[i + 4] = 0;
                ++i;
            }
            RTalk.setHdr(4, sl, rq, 0);
            return this.request(cmd, rq);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public RPacket request(int cmd, int par) {
        try {
            byte[] rq = new byte[8];
            RTalk.setInt(par, rq, 4);
            RTalk.setHdr(1, 4, rq, 0);
            return this.request(cmd, rq);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

