/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.matlablink;

import java.io.File;
import java.io.IOException;
import org.simantics.matlablink.CellArray;
import org.simantics.matlablink.CharacterArray;
import org.simantics.matlablink.DoubleArray;
import org.simantics.matlablink.Engine;
import org.simantics.matlablink.MatlabArray;
import org.simantics.matlablink.StructArray;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;

public class Matlab {
    public static final String ENGINE = "Simantics/Matlab/Matlab";

    public static Engine openEngine(File workingDirectory) {
        if (workingDirectory == null || !workingDirectory.exists() || !workingDirectory.isDirectory()) {
            throw new IllegalArgumentException("Working directory is not an existing directory");
        }
        Engine engine = new Engine(workingDirectory.getAbsolutePath());
        if (!engine.isOpen()) {
            throw new RuntimeException("Opening Matlab engine failed");
        }
        return engine;
    }

    public static Object runMatlab(File workingDirectory, Function fun) {
        SCLContext context = SCLContext.getCurrent();
        Engine oldEngine = (Engine)context.get((Object)ENGINE);
        try {
            Object object;
            block15: {
                Throwable throwable = null;
                Object var5_7 = null;
                Engine newEngine = Matlab.openEngine(workingDirectory);
                try {
                    context.put((Object)ENGINE, (Object)newEngine);
                    object = fun.apply((Object)Tuple0.INSTANCE);
                    if (newEngine == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        if (newEngine != null) {
                            newEngine.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                newEngine.close();
            }
            context.put((Object)ENGINE, (Object)oldEngine);
            return object;
        }
        catch (Throwable throwable) {
            context.put((Object)ENGINE, (Object)oldEngine);
            throw throwable;
        }
    }

    public static Object runWithEngine(Engine engine, Function fun) {
        SCLContext context = SCLContext.getCurrent();
        Engine oldEngine = (Engine)context.get((Object)ENGINE);
        try {
            context.put((Object)ENGINE, (Object)engine);
            Object object = fun.apply((Object)Tuple0.INSTANCE);
            return object;
        }
        finally {
            context.put((Object)ENGINE, (Object)oldEngine);
        }
    }

    public static Object matchMatlabArray(MatlabArray array, Function doubleFun, Function stringFun, Function cellFun, Function structFun) {
        if (array instanceof DoubleArray) {
            return doubleFun.apply((Object)array);
        }
        if (array instanceof CharacterArray) {
            return stringFun.apply((Object)array);
        }
        if (array instanceof CellArray) {
            return cellFun.apply((Object)array);
        }
        if (array instanceof StructArray) {
            return structFun.apply((Object)array);
        }
        throw new IllegalArgumentException("Unknown Matlab array type: " + array.getClass().getName());
    }
}

