/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.ui.wizard;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.simantics.utils.ui.widgets.DirectorySelectionWidget;
import org.simantics.utils.ui.widgets.FileOrDirectorySelectionWidget;
import org.simantics.utils.ui.widgets.FileSelectionListener;
import org.simantics.utils.ui.widgets.FileSelectionWidget;

public class InputSelectionPage
extends WizardPage
implements FileSelectionListener {
    private FileSelectionWidget schemaSelection;
    private FileSelectionWidget configurationSelection;
    private DirectorySelectionWidget pluginSelection;
    boolean createPGraph = true;
    boolean createImporter = true;
    boolean createExporter = true;

    public InputSelectionPage() {
        super("InputPage", "Select input files and output plug-in", null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        this.schemaSelection = new FileSelectionWidget(composite, "Schema file", 4096);
        this.configurationSelection = new FileSelectionWidget(composite, "Configuration file (Optional)", 4096);
        this.pluginSelection = new DirectorySelectionWidget(composite, "Output plug-in", 8192);
        this.schemaSelection.setFilterExtensions(new String[]{"*.xsd"});
        this.schemaSelection.setFilterNames(new String[]{"XML schema files"});
        this.configurationSelection.setFilterExtensions(new String[]{"*.xml"});
        this.configurationSelection.setFilterNames(new String[]{"XML files"});
        this.schemaSelection.addListener((FileSelectionListener)this);
        this.pluginSelection.addListener((FileSelectionListener)this);
        final Button pGraphButton = new Button(composite, 32);
        final Button importButton = new Button(composite, 32);
        final Button exportButton = new Button(composite, 32);
        pGraphButton.setText("Create Ontology / .pgraph file");
        importButton.setText("Create Importer");
        exportButton.setText("Create Exporter");
        pGraphButton.setSelection(this.createPGraph);
        importButton.setSelection(this.createImporter);
        exportButton.setSelection(this.createExporter);
        pGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputSelectionPage.this.createPGraph = pGraphButton.getSelection();
            }
        });
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputSelectionPage.this.createImporter = importButton.getSelection();
            }
        });
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputSelectionPage.this.createExporter = exportButton.getSelection();
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    public void fileSelected(FileOrDirectorySelectionWidget source, String[] filename) {
        this.setPageComplete(this.schemaSelection.getFilename() != null && this.pluginSelection.getFilename() != null);
    }

    public boolean isCreateExporter() {
        return this.createExporter;
    }

    public boolean isCreateImporter() {
        return this.createImporter;
    }

    public boolean isCreatePGraph() {
        return this.createPGraph;
    }

    public String getSchemaFilename() {
        if (this.schemaSelection.getFilename() == null || this.schemaSelection.getFilename().length == 0) {
            return null;
        }
        return this.schemaSelection.getFilename()[0];
    }

    public String getConfigurationFilename() {
        if (this.configurationSelection.getFilename() == null || this.configurationSelection.getFilename().length == 0) {
            return null;
        }
        return this.configurationSelection.getFilename()[0];
    }

    public String getPluginFilename() {
        if (this.pluginSelection.getFilename() == null || this.pluginSelection.getFilename().length == 0) {
            return null;
        }
        return this.pluginSelection.getFilename()[0];
    }
}

