/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.update.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.update.model.UpdateOp;

public abstract class UpdateOperations {
    private List<UpdateOp> operations = new ArrayList<UpdateOp>();
    private Map<Resource, UpdateOp> resourceMap = new HashMap<Resource, UpdateOp>();
    private Map<Statement, UpdateOp> statementMap = new HashMap<Statement, UpdateOp>();
    private GraphChanges changes;

    public UpdateOperations(GraphChanges changes) {
        this.changes = changes;
    }

    public UpdateOp getUpdateOp(Resource r) {
        return this.resourceMap.get(r);
    }

    public UpdateOp getUpdateOp(Statement s) {
        return this.statementMap.get(s);
    }

    public void applyAll(WriteGraph g) throws DatabaseException {
        for (UpdateOp op : this.operations) {
            this.apply(g, op);
        }
    }

    public void applySelected(WriteGraph g) throws DatabaseException {
        for (UpdateOp op : this.operations) {
            if (!op.selected()) continue;
            this.apply(g, op);
        }
    }

    public List<UpdateOp> getOperations() {
        return this.operations;
    }

    public GraphChanges getChanges() {
        return this.changes;
    }

    public Map<Resource, UpdateOp> getResourceMap() {
        return this.resourceMap;
    }

    public Map<Statement, UpdateOp> getStatementMap() {
        return this.statementMap;
    }

    private void apply(WriteGraph g, UpdateOp op) throws DatabaseException {
        Stack<UpdateOp> stack = new Stack<UpdateOp>();
        this._apply(g, stack, op);
    }

    private void _apply(WriteGraph g, Stack<UpdateOp> stack, UpdateOp op) throws DatabaseException {
        if (op.applied()) {
            return;
        }
        if (stack.contains(op)) {
            op.apply(g);
            return;
        }
        stack.push(op);
        if (op.requiresParentOps()) {
            for (UpdateOp pop : op.getParentOps()) {
                if (pop.applied()) continue;
                this._apply(g, stack, pop);
            }
        }
        if (op.requiresSubOps()) {
            for (UpdateOp sop : op.getSubOps()) {
                if (sop.applied()) continue;
                this._apply(g, stack, sop);
            }
        }
        stack.pop();
        op.apply(g);
    }

    protected List<UpdateOp> getOps() {
        ArrayList<UpdateOp> list = new ArrayList<UpdateOp>(this.operations.size());
        list.addAll(this.operations);
        return list;
    }

    protected void addOp(Resource r, UpdateOp op) {
        this.resourceMap.put(r, op);
        this.operations.add(op);
    }

    protected void addOp(Statement s, UpdateOp op) {
        this.statementMap.put(s, op);
        this.operations.add(op);
    }

    protected void replaceOp(Resource r, UpdateOp op) {
        UpdateOp oldOp = this.resourceMap.remove(r);
        if (oldOp != null) {
            this.operations.remove(oldOp);
        }
        this.resourceMap.put(r, op);
        this.operations.add(op);
    }

    protected UpdateOp getOP(Resource r) {
        return this.resourceMap.get(r);
    }

    protected UpdateOp getOP(Statement r) {
        return this.statementMap.get(r);
    }

    public abstract void populate(ReadGraph var1) throws DatabaseException;

    protected boolean compares(Resource r1, Resource r2) {
        if (r1.equals(r2)) {
            return true;
        }
        return this.changes.getComparable().contains((Object)r1, (Object)r2);
    }
}

